'use strict';

/* --------------------------------------------------------------
 shop_offline.js 2016-09-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * General Controller of Shop Online/Offline
 */
gx.controllers.module('shop_offline', [], function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES
    // ------------------------------------------------------------------------

    /**
     * Module Selector
     *
     * @type {jQuery}
     */

    var $this = $(this);

    /**
     * Module Instance
     *
     * @type {Object}
     */
    var module = {};

    // ------------------------------------------------------------------------
    // FUNCTIONS
    // ------------------------------------------------------------------------

    function _toggleLanguageSelection() {
        var $languagesButtonBar = $('.languages.buttonbar');

        if ($(this).attr('href') === '#status') {
            $languagesButtonBar.css('visibility', 'hidden');
        } else {
            $languagesButtonBar.css('visibility', 'visible');
        }
    }

    function _correctCodeMirrorDisplay() {
        setTimeout(function () {
            $('.CodeMirror:visible').each(function (index, codeMirror) {
                codeMirror.CodeMirror.refresh();
            });
        }, 100);
    }

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.find('.tab-headline-wrapper > a').on('click', _toggleLanguageSelection).on('click', _correctCodeMirrorDisplay);

        _toggleLanguageSelection.call($('.tab-headline-wrapper a')[0]);

        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
